# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Deploy a SharePoint solution
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# File path to the solution file
$solutionPath = "C:\Packages\Code6587EN.Ch04.wsp"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

$solutionName = [System.IO.Path]::GetFileName($solutionPath)

# Check if solution exists on farm
$farmSolution = Get-SPSolution -Identity $solutionName -ErrorAction SilentlyContinue
if ($farmSolution -eq $null)
{
	# If is not on the farm, add it
	Add-SPSolution $solutionPath -Confirm:$false -ErrorAction Stop | Out-Null

	# Get the added solution
	$farmSolution = Get-SPSolution -Identity $solutionName -ErrorAction Stop
	
	# Check if the solution has web application resources	
	if ($farmSolution.ContainsWebApplicationResource -eq $true)
	{
		# Deploy to all content web applications
		Install-SPSolution -Identity $solutionName -GACDeployment -AllWebApplications -Force -Confirm:$false -ErrorAction Stop | Out-Null				
	}
	else
	{
		# Deploy to the farm
		Install-SPSolution -Identity "$wspName" -GACDeployment -Force -Confirm:$false -ErrorAction Stop | Out-Null
	}	
}
else 
{
	# Check if the existing solution is deployed
	if ($farmSolution.Deployed -eq $false)
	{
		# Delete the existing solution that is not deployed
		$farmSolution.Delete()
			
		# Add the solution
		Add-SPSolution $solutionPath -Confirm:$false -ErrorAction Stop | Out-Null

		# Get the added solution
		$farmSolution = Get-SPSolution -Identity $solutionName -ErrorAction Stop
	
		# Check if the solution has web application resources	
		if ($farmSolution.ContainsWebApplicationResource -eq $true)
		{
			# Deploy to all content web applications
			Install-SPSolution -Identity $solutionName -GACDeployment -AllWebApplications -Force -Confirm:$false -ErrorAction Stop | Out-Null				
		}
		else
		{
			# Deploy to the farm
			Install-SPSolution -Identity $solutionName -GACDeployment -Force -Confirm:$false -ErrorAction Stop | Out-Null
		}
	}
	else		
	{
		# Update the existing deployed solution
		Update-SPSolution -LiteralPath $solutionPath -Identity $solutionName -GACDeployment -Force -Confirm:$false -ErrorAction Stop | Out-Null
	}
}

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 